#ifndef __NUMBER_FIELD_H__
#define __NUMBER_FIELD_H__

typedef struct NumberField NumberField;

#include <stdbool.h>

struct NumberField {
	bool editable;
	float value;
	float incrementPerPixel;
	float incrementMultiplier;
	void (* valueChangeCallback)(void *, float);
	void * context;
	int color;
	int positionX;
	int positionY;
};

NumberField NumberField_create(bool inEditable, float inValue, float inIncrementPerPixel, void (* inValueChangeCallback)(void *, float), void * inContext, int inColor, int inPositionX, int inPositionY);
void NumberField_setValue(NumberField * self, float value);
bool NumberField_hitTest(NumberField * self, int x, int y);
void NumberField_mouseDragged(NumberField * self, int x, int y);
void NumberField_draw(NumberField * self, bool dragging);

#endif
